const axios = require("axios");
const Favorite = require("../models/Favorite");

const searchMovies = async (req, res) => {
  const { title } = req.query;
  if (!title)
    return res.status(400).json({ message: "title query is required" });
  try {
    const response = await axios.get(
      `https://www.omdbapi.com/?apikey=${
        process.env.OMDB_API_KEY
      }&s=${encodeURIComponent(title)}`
    );
    res.json(response.data);
  } catch (err) {
    console.error(err.message);
    res.status(500).json({ message: "Error fetching movies" });
  }
};

const getMovieDetails = async (req, res) => {
  const { id } = req.params;
  try {
    const response = await axios.get(
      `https://www.omdbapi.com/?apikey=${
        process.env.OMDB_API_KEY
      }&i=${encodeURIComponent(id)}&plot=full`
    );
    res.json(response.data);
  } catch (err) {
    console.error(err.message);
    res.status(500).json({ message: "Error fetching details" });
  }
};

const addFavorite = async (req, res) => {
  try {
    const { imdbID, title, poster } = req.body;
    if (!imdbID) return res.status(400).json({ message: "imdbID required" });
    const existing = await Favorite.findOne({ imdbID });
    if (existing) return res.status(200).json(existing);
    const fav = await Favorite.create({ imdbID, title, poster });
    res.json(fav);
  } catch (err) {
    console.error(err.message);
    res.status(500).json({ message: "Error adding favorite" });
  }
};

const getFavorites = async (req, res) => {
  try {
    const favs = await Favorite.find().sort({ addedAt: -1 });
    res.json(favs);
  } catch (err) {
    console.error(err.message);
    res.status(500).json({ message: "Error fetching favorites" });
  }
};

const removeFavorite = async (req, res) => {
  try {
    const { id } = req.params;
    const deleted = await Favorite.findByIdAndDelete(id);
    if (!deleted) {
      return res.status(404).json({ message: "Favorite not found" });
    }
    res.json({ message: "Removed from favorites", deleted });
  } catch (err) {
    console.error(err.message);
    res.status(500).json({ message: "Error removing favorite" });
  }
};


module.exports = { searchMovies, getMovieDetails, addFavorite, getFavorites, removeFavorite };
